using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class SURVEY_RESULTSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SURVEY_RESULTSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<SURVEY_RESULTS> GetItemsBySurvey(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SURVEYS_ID)
        {
            List<SURVEY_RESULTS> objReturn = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_SURVEY_RESULTS_getitemsBySurvey(CURRENT_USER, CURRENT_REGISTRY_ID, SURVEYS_ID).ToList();
                    objReturn = dbContext.usp_SURVEY_RESULTS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objReturn = objReturn.Where(r => r.SURVEYS_ID == SURVEYS_ID).ToList();

                    if (objReturn != null)
                    {
                        foreach (SURVEY_RESULTS sr in objReturn)
                        {
                            if (sr.STD_QUESTION_ID > 0)
                            {
                                sr.STD_QUESTION = dbContext.usp_STD_QUESTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, sr.STD_QUESTION_ID).FirstOrDefault();
                            }

                            if (sr.STD_QUESTION_CHOICE_ID != null && sr.STD_QUESTION_CHOICE_ID > 0)
                            {
                                sr.STD_QUESTION_CHOICE = dbContext.usp_STD_QUESTION_CHOICE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, sr.STD_QUESTION_CHOICE_ID.Value).FirstOrDefault();
                            }
                        }
                    }

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean SaveAll(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, List<SURVEY_RESULTS> results)
        {
            if (results == null)
                return false;

            Boolean objReturn = false;
            Int32? objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    foreach (SURVEY_RESULTS objSave in results)
                    {
                        objTemp = objSave.SURVEY_RESULT_ID;
                        LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                        dbContext.usp_SURVEY_RESULTS_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.RESULT_TEXT, objSave.SELECTED_FLAG, objSave.STD_QUESTION_CHOICE_ID, objSave.STD_QUESTION_ID, ref objTemp, objSave.SURVEYS_ID, DateTime.Now, objSave.UPDATEDBY, objSave.COMMENTS_TEXT);
                        LogManager.LogTiming(logDetails);
                    }

                    objReturn = true;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
